//O[o
Texture2D g_texColor: register(t0);
SamplerState g_samLinear : register(s0);

//O[o
cbuffer global_0:register(b0)
{
	matrix g_mW;//[hs
	matrix g_mWV;//[hxr[ss
	matrix g_mWVP; //[hˉe܂ł̕ϊs
	float4 g_vLightDir;  //Cg̕xNg
	float4 g_vEye;//Jʒu
};

cbuffer global_1:register(b1)
{
	float4 g_Ambient=float4(0,0,0,0);//ArGg
	float4 g_Diffuse=float4(1,0,0,0); //gU(Fj
	float4 g_Specular=float4(1,1,1,1);//ʔ
};

//o[ebNXVF[_[o͍\
struct VS_OUTPUT
{	
	float4 Pos : SV_POSITION;
	float4 Color : COLOR0;
	float3 Light : TEXCOORD0;
	float3 Normal : TEXCOORD1;
	float3 EyeVector : TEXCOORD2;
	float2 Tex : TEXCOORD3;
};
//
//o[ebNXVF[_[
//
VS_OUTPUT VS( float4 Pos : POSITION ,float4 Norm : NORMAL,float2 Tex : TEXCOORD)
{
	VS_OUTPUT output = (VS_OUTPUT)0;
	//ˉeϊi[hr[vWFNVj
	//@[hԂ
	output.Normal=mul(Norm, (float3x3) g_mW);
	output.Pos=mul(Pos,g_mWVP);
	//Cg
	output.Light=g_vLightDir;
	//xNg
	float3 PosWorld = mul(Pos,g_mW); 
	output.EyeVector = g_vEye - PosWorld;
	//eNX`[W
	//@ɋʃeNX`[W
	//̖@̓JW̎_̂̂g߁Ar[ϊ_̖@߂
	float3 Normal_v=mul(Norm,(float3x3)g_mWV);
	output.Tex.x=Normal_v.x/2+0.5;
	output.Tex.y=Normal_v.y/2+0.5;

	return output;
}

//
//sNZVF[_[
//
float4 PS( VS_OUTPUT input ) : SV_Target
{
	float4 color=g_texColor.Sample( g_samLinear, input.Tex );
	
	//ŃtHƖfɂVF[fBOF肵Ă

	//fBt[Y̌vZ@o[gƓ
	float3 Normal = normalize(input.Normal);
	float3 LightDir = normalize(input.Light);
	float3 ViewDir = normalize(input.EyeVector); 
	float4 NL = saturate(dot(Normal, LightDir)); 

	//XyL
	float3 Reflect = normalize(2 * NL * Normal - LightDir);
	float4 specular = pow(saturate(dot(Reflect, ViewDir)), 4); 

	//fBt[YƃXyL𑫂čŏIF
	float4 Phong= g_Diffuse * NL + specular*g_Specular;
	color+=Phong;

	return color;
}